/*
 * Decompiled with CFR 0.152.
 */
package pub.pigeon.yggdyy.hexcreating.blocks.board;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import pub.pigeon.yggdyy.hexcreating.items.ModItems;

public class AllBoardPasters {
    public static List<BoardPaster> pasters = new ArrayList<BoardPaster>(List.of());

    public static void add(BoardPaster plaster) {
        if (!pasters.contains(plaster)) {
            pasters.add(plaster);
        }
    }

    public static void init() {
        AllBoardPasters.add(new BoardPaster(){

            @Override
            public boolean canHandle(class_1799 stack, class_3218 world) {
                return stack.method_31574((class_1792)ModItems.PRINTED_PAPER) && stack.method_7985() && stack.method_7969().method_10545("iota");
            }

            @Override
            public List<IItemStackMatcher> getResult(class_1799 stack, class_3218 world) {
                ArrayList<IItemStackMatcher> res = new ArrayList<IItemStackMatcher>(List.of());
                class_2487 nbt = ModItems.PRINTED_PAPER.readIotaTag(stack);
                if (nbt == null) {
                    return res;
                }
                ListIota list = (ListIota)IotaType.deserialize((class_2487)nbt, (class_3218)world);
                for (Iota now : list.getList()) {
                    if (!(now instanceof PatternIota)) continue;
                    PatternIota pIota = (PatternIota)now;
                    ItemStackMatcher matcher = new ItemStackMatcher();
                    String stroke = pIota.getPattern().anglesSignature();
                    class_1799 _s = new class_1799((class_1935)ModItems.SQUARE);
                    ModItems.SQUARE.writeDatum(_s, (Iota)new PatternIota(pIota.getPattern()));
                    for (HexDir dir : HexDir.values()) {
                        HexPattern p = HexPattern.fromAngles((String)stroke, (HexDir)dir);
                        class_1799 s = new class_1799((class_1935)ModItems.SQUARE);
                        ModItems.SQUARE.writeDatum(s, (Iota)new PatternIota(p));
                        matcher.add(s, _s);
                    }
                    matcher.add(new class_1799((class_1935)ModItems.SQUARE), _s);
                    res.add(matcher);
                }
                return res;
            }
        });
        AllBoardPasters.add(new BoardPaster(){

            @Override
            public boolean canHandle(class_1799 stack, class_3218 world) {
                return stack.method_31574((class_1792)HexItems.SLATE);
            }

            @Override
            public List<IItemStackMatcher> getResult(class_1799 stack, class_3218 world) {
                ItemStackMatcher res = new ItemStackMatcher();
                Iota iota = HexItems.SLATE.readIota(stack, world);
                if (iota == null || !(iota instanceof PatternIota)) {
                    return List.of(res);
                }
                PatternIota pIota = (PatternIota)iota;
                String stroke = pIota.getPattern().anglesSignature();
                class_1799 _s = new class_1799((class_1935)ModItems.SQUARE);
                ModItems.SQUARE.writeDatum(_s, (Iota)new PatternIota(pIota.getPattern()));
                for (HexDir dir : HexDir.values()) {
                    HexPattern p = HexPattern.fromAngles((String)stroke, (HexDir)dir);
                    class_1799 s = new class_1799((class_1935)ModItems.SQUARE);
                    ModItems.SQUARE.writeDatum(s, (Iota)new PatternIota(p));
                    res.add(s, _s);
                }
                res.add(new class_1799((class_1935)ModItems.SQUARE), _s);
                return List.of(res);
            }
        });
        AllBoardPasters.add(new BoardPaster(){

            @Override
            public boolean canHandle(class_1799 stack, class_3218 world) {
                return stack.method_31574((class_1792)HexItems.FOCUS);
            }

            @Override
            public List<IItemStackMatcher> getResult(class_1799 stack, class_3218 world) {
                return List.of();
            }
        });
    }

    public static interface BoardPaster {
        public boolean canHandle(class_1799 var1, class_3218 var2);

        public List<IItemStackMatcher> getResult(class_1799 var1, class_3218 var2);
    }

    public static class ItemStackMatcher
    implements IItemStackMatcher {
        public List<class_3545<class_1799, class_1799>> list = new ArrayList<class_3545<class_1799, class_1799>>(List.of());

        public void add(class_1799 stackIn, class_1799 stackOut) {
            this.list.add((class_3545<class_1799, class_1799>)new class_3545((Object)stackIn, (Object)stackOut));
        }

        @Override
        public List<class_3545<class_1799, class_1799>> get() {
            return this.list;
        }
    }

    @FunctionalInterface
    public static interface IItemStackMatcher {
        public List<class_3545<class_1799, class_1799>> get();
    }
}

